//
//  calcPerfClass.h
//  H135
//
//  Created by Claus Richter on 10/29/17.
//
//

#import <UIKit/UIKit.h>

@interface calcPerfClass : UIViewController {
    
    CAShapeLayer *circleLayer;
    UIBezierPath *pathC;
    
    NSString *specialChart;
    
    float merkerHp, merkerOAT;
    
    float resultOEIMCPCeiling, resultHoehenverlusst , resultHoehenverlusstMEA2;
    
    float Seg1Vtoss_Selected;
    float Seg2Vtoss_Selected;
    
    float OEIMCPGrad3000; // 2000 ft ISA
    float OEIMCPGrad4000; // 3000 ft ISA
    float OEIMCPGrad5000; // 4000 ft ISA
    
    int flagPC2error;
    
    UIView *viewCross1;    
    UIView *viewCross2;
    UIView *viewCross3;
    UIView *viewCross4;

    int totalCeilingSteps1;
    int totalCeilingSteps2;
    int totalCeilingSteps3;
    int totalCeilingSteps4;
    int totalCeilingStepsOLD;
    
    // calc performance
    
    NSMutableArray *resultsAllChartNames;
    NSMutableArray *resultsAllChartUserNames;
    NSMutableArray *resultsAllChartValues;
    NSMutableArray *resultsAllUnits;
    
    NSString *arrayKey;
    
    NSString *serverUrl;
    NSString *ACCategory;
    NSString *ACmanufacturer;
    NSString *AC_Type;
    NSString *ACVariant;
    
    NSArray *chartsArray;
    
    int numberOfChartsForThisAircraft;
    
    int actualButtonNumber;
    
    int flagDrawACweightLines;
    
    int nChart;
    
    NSArray *infoArray;
    
    float weightTOW;
    
    int chartNumberForResult;
    
    float selectedChartButton, fullScreenPerfCharts;
    
    NSString *chartNameForThisInfoFile;
    
    NSString *chartNameToLoad;
    
    
    // get getInfoForCurrentChart
    
    int  numberOfComputationParts;
    
    NSString *chartUserName;
    
    NSString *limitationsForHoist;
    
    
    
    // loopAllPartsAndSaveResults
    
    int partNumberToCompute;
    
    int infoPartNumber;
    
    int flagThisPartResultContainsTransferValue;
    
    float factorForResult;
    
    float resultComputation;
    
    NSMutableDictionary *transferValueDictionary;
    
    NSString *unitResult;
    
    
       
   // writeButtonLabels
    
    float resultFromComputations;
    
    NSString *chartNameForComputation;
    NSString *userNameForComputation;
    NSString *unitNameForComputation;
    
    UILabel *dL;
    
    // drawCrossesAndLines
    
    int nCross;
    
    int newWPDdataAvialable;
    
    NSArray *infoPartArray;
    
    float xPix1, xPix2, xPix3, yPix1, yPix2, yPix3;
    
    float chartWidthPixel, chartHeightPixel;
    
    float xLeftChart, yBottomChart, xRightChart, yTopChart, xLeftGC, yBottomGC, xRightGC, yTopGC;
    
    float chartWidthInApp, chartHeightInApp, xposition, yposition, Xinput, Yinput;
    
    float cross1ValueX, cross1ValueY, cross2ValueX, cross2ValueY, cross3ValueX, cross3ValueY, cross4ValueX, cross4ValueY;
    
    
    
    // draw line
    
    NSString *crossLineSequence;
    
    int yToX;
    
    float minInput, maxInput, lineBaseLeftX,lineBaseRightX,  minResult, maxResult, lineBaseBottomY, lineBaseTopY;
    
    UIBezierPath *pathLine;
    
    float drawToFixedPointX, drawToFixedPointY;
    
    float markerPointX1;
    
    int flagOATisXaxis;
    
    
    // computeChartSizeInApp
    
    float flagChartsFitToScreenHeight;
    
    float pinchScale, moveLeftRight, moveupDown, pinchScaleEnded;
    
    
    // loadChartImage
    
    NSString *previousChartName;
    
    UIImage *PerfChartImage;
    
    
    
    
    
    // getInfoFileForThisPart
    
    float minCurve, maxCurve, maxResultWithRestriction;    
    
    float hoistLoadAttached;
    
    
    
    
    // getInputForCurveAndAxis
    
    float givenCurveInputValue;
    
    float OAT, Hp, acWeight, headWindKTS, unchangedACWeight, fuelWeight, DensityAlt;
    
    float givenAxisInputValue;
    
    
    // checkInputDataRange
    
    int flagInputDataOutOfRange;
    
    
    // calcComputation
    
    NSArray *availableCurvesArray;
    
    
    // limitResultValues
    
    int flagOutputDataOutOfRange;
    
    
    
    NSData *chartImageData; //saved as signatureImage
    
    UIImage *chartImageFile; //
    
    
    NSMutableDictionary *chartImagesDictionary;
    
    float ISADiff;
    float altimeterInches;
    
    int flagCeilingComputation;
    
    float interpolationResult;
    
    float penaltyWeight;
    float penaltyFtMin;
    
    
    float TDPheight;
    float RearwardTODist;
    float MinHeight;
    float HeightAchievedVTOSS;
    float contTODist;
    
    float ISADIFFCelsius;
        
    float resultCG2minPercent, resultCGMCPPercent;
    
}

- (void) transferMethod:  (float)receivedOAT  sendPA:(float)receivedPA  sendHeadWindKts:(float)receivedHeadWindKts sendACweight:(float)receivedACweight sendSelectedChartButton:(float)receivedSelectedChartButton   sendISADiff:(float)receivedISADiff   sendAltimeterInches:(float)receivedAltimeterInches sendPenaltyWeight:(float)receivedPenaltyWeight sendPenaltyFtMin:(float)receivedPenaltyFtMin sendFuelWeight:(float)receivedFuelWeight sendDA:(float)receivedDA sendISADIFF:(float)receivedISADIFF;

- (void) resetInputObstacleHeight;

- (void) setEnvironmentDataMixedCG;


//- (void) interpolationMethod: (float)receivedBaseValue lowVal:(float)receivedLowVal highVal:(float)receivedHighVal lowSearch:(float)receivedLowSearch highSearch:(float)receivedHighSearch;

// writeButtonLabels

@property (strong, nonatomic) IBOutlet UIView *viewUniversalButtons;


// drawCrossesAndLines


@property (strong, nonatomic) IBOutlet UIView *viewLinesOnChart;

@property (strong, nonatomic) IBOutlet UIImageView *universalChartGraphic;


// computeChartSizeInApp

@property (strong, nonatomic) IBOutlet UIView *masterViewCharts;

@property (strong, nonatomic) IBOutlet UIView *viewChartContainer;

@property (strong, nonatomic) IBOutlet UIView *viewChartsUniversal;


- (void) resetPreviousChartName;


@property (strong, nonatomic) IBOutlet UIView *viewCATAOverview1;

@property (strong, nonatomic) IBOutlet UIView *viewCATAOverview2;

@property (strong, nonatomic) IBOutlet UIView *viewCATAOverview3;

@property (strong, nonatomic) IBOutlet UIView *viewCATAOverview4;




@property (strong, nonatomic) IBOutlet UILabel *labelCurrentACweight;


@property (strong, nonatomic) IBOutlet UILabel *labelFuelWeight;

@property (strong, nonatomic) IBOutlet UILabel *labelDensityAlt;



@property (strong, nonatomic) IBOutlet UILabel *interpolatedSeg1OEIMCPGrad;
@property (strong, nonatomic) IBOutlet UILabel *interpolatedSeg2OEIMCPGrad;;


@property (strong, nonatomic) IBOutlet UILabel *interpolatedSeg2ORIMCPGrad3000;
@property (strong, nonatomic) IBOutlet UILabel *interpolatedSeg2ORIMCPGrad4000;
@property (strong, nonatomic) IBOutlet UILabel *interpolatedSeg2ORIMCPGrad5000;


@property (strong, nonatomic) IBOutlet UILabel *addGain2Vy;

@property (strong, nonatomic) IBOutlet UILabel *catAEnRouteOEIMCPCeiling;


@property (strong, nonatomic) IBOutlet UILabel *MTOWcorrectionPenalty;
@property (strong, nonatomic) IBOutlet UILabel *HeightGainCorrectionPenalty;

@property (strong, nonatomic) IBOutlet UILabel *MTOWcorrectionPenalty2;
@property (strong, nonatomic) IBOutlet UILabel *HeightGainCorrectionPenalty2;

@property (strong, nonatomic) IBOutlet UILabel *MTOWcorrectionPenalty3;
@property (strong, nonatomic) IBOutlet UILabel *HeightGainCorrectionPenalty3;





@property (strong, nonatomic) IBOutlet UILabel *MTOWcorrected;




@property (strong, nonatomic) IBOutlet UILabel *chRejectedTOdist;

@property (strong, nonatomic) IBOutlet UILabel *chContTOdist;

@property (strong, nonatomic) IBOutlet UILabel *chAccelDist;

@property (strong, nonatomic) IBOutlet UILabel *chLandingDist;




@property (strong, nonatomic) IBOutlet UILabel *AEOHIGETOP;
@property (strong, nonatomic) IBOutlet UILabel *AEOHOGETOP;
@property (strong, nonatomic) IBOutlet UILabel *AEOHIGE2min;
@property (strong, nonatomic) IBOutlet UILabel *AEOHOGE2min;
@property (strong, nonatomic) IBOutlet UILabel *AEOHOGE30sec;


- (IBAction)actionSwitchCATAVTOL:(id)sender;


@property (strong, nonatomic) IBOutlet UIView *viewCATACH;

@property (strong, nonatomic) IBOutlet UIView *viewVTOL;

@property (strong, nonatomic) IBOutlet UILabel *VTOLMaxMass;
@property (strong, nonatomic) IBOutlet UILabel *VTOLMaxMassCeiling;

@property (strong, nonatomic) IBOutlet UILabel *VTOLAccelerationDistance;
@property (strong, nonatomic) IBOutlet UILabel *VTOLMaxMassTraining;


@property (strong, nonatomic) IBOutlet UILabel *CHMaxMass;
@property (strong, nonatomic) IBOutlet UILabel *CHCeiling;



@property (strong, nonatomic) IBOutlet UITextField *inputObstacleHeightMeter;


@property (strong, nonatomic) IBOutlet UILabel *labelMinHeight;

@property (strong, nonatomic) IBOutlet UILabel *labelTDPHeight;

@property (strong, nonatomic) IBOutlet UILabel *labelRearwardTODist;

@property (strong, nonatomic) IBOutlet UILabel *labelHeightAchieved;

@property (strong, nonatomic) IBOutlet UILabel *labelContinuedTODist;


- (IBAction)closeKeyboard:(id)sender;


@property (strong, nonatomic) IBOutlet UILabel *seg2Distance;

@property (strong, nonatomic) IBOutlet UILabel *seg1Distance;
@property (strong, nonatomic) IBOutlet UILabel *seg1Percent;


@property (strong, nonatomic) IBOutlet UILabel *catAClearHeliSgement1Distance;

@property (strong, nonatomic) IBOutlet UILabel *catAClearHeliSgement2Distance;


@property (strong, nonatomic) IBOutlet UILabel *catAClearHeliTOTALDIstance;

@property (strong, nonatomic) IBOutlet UILabel *catAVTOLTOTALDIstance;


@property (strong, nonatomic) IBOutlet UISlider *sliderObstHeight;

- (IBAction)sliderActionObstHeight:(id)sender;


@property (strong, nonatomic) IBOutlet UILabel *PC2PIS8;

@property (strong, nonatomic) IBOutlet UILabel *PC2CeilingMTOM;

@property (strong, nonatomic) IBOutlet UILabel *PC2OEIROC150;


@property (strong, nonatomic) IBOutlet UILabel *labelOATat2000;
@property (strong, nonatomic) IBOutlet UILabel *labelOATat3000;
@property (strong, nonatomic) IBOutlet UILabel *labelOATat4000;

@property (strong, nonatomic) IBOutlet UIButton *switchCATAVTOL;



@property (strong, nonatomic) IBOutlet UIView *viewMixedCG;
@property (strong, nonatomic) IBOutlet UIView *viewDriftDown;

//********************************
// Mixed CG

@property (strong, nonatomic) IBOutlet UITextField *mcgInputAirportElevationMSL;
@property (strong, nonatomic) IBOutlet UISlider *mcgSliderAirportElevationMSL;
- (IBAction)mcgSliderActionAirportElevationSID:(id)sender;


@property (strong, nonatomic) IBOutlet UILabel *lSidMapTop;


@property (strong, nonatomic) IBOutlet UILabel *labelDifferenceAirportElevToSid;


@property (strong, nonatomic) IBOutlet UILabel *lVy;
@property (strong, nonatomic) IBOutlet UILabel *lVyinFtMin;
@property (strong, nonatomic) IBOutlet UILabel *lCG2min;
@property (strong, nonatomic) IBOutlet UILabel *lClimbRate2min;
@property (strong, nonatomic) IBOutlet UILabel *labelTime2Min;
@property (strong, nonatomic) IBOutlet UILabel *lTotalClimb2Min;
@property (strong, nonatomic) IBOutlet UILabel *lCGMCP;
@property (strong, nonatomic) IBOutlet UILabel *lClimbRateMCP;
@property (strong, nonatomic) IBOutlet UILabel *lTimeMCP;
@property (strong, nonatomic) IBOutlet UILabel *lTotalClimbMCP;
@property (strong, nonatomic) IBOutlet UILabel *lTotalTime;
@property (strong, nonatomic) IBOutlet UILabel *lMixedCGPercent;

- (IBAction)closeKeyboardAirportElevation:(id)sender;
@property (strong, nonatomic) IBOutlet UIView *viewColorMixedCG;

@property (strong, nonatomic) IBOutlet UILabel *hinweisMixedCG;


@property (strong, nonatomic) IBOutlet UILabel *lResultOEIMCPCeiling;

@property (strong, nonatomic) IBOutlet UITextField *inputMEA1elevation;
@property (strong, nonatomic) IBOutlet UITextField *inputMEA1distance;
@property (strong, nonatomic) IBOutlet UILabel *lMEA1diffToSC;
@property (strong, nonatomic) IBOutlet UILabel *lSliderGeschUeberhoehung;
@property (strong, nonatomic) IBOutlet UISlider *sliderGeschUeber;
- (IBAction)sliderActionGeschUeber:(id)sender;
@property (strong, nonatomic) IBOutlet UILabel *lUeberhoehungTotal;
@property (strong, nonatomic) IBOutlet UILabel *lhoehenverlusst;
@property (strong, nonatomic) IBOutlet UILabel *lhoehenverlusstTotal;
@property (strong, nonatomic) IBOutlet UILabel *lUeberhoehungFuerGanzesLeg;
@property (strong, nonatomic) IBOutlet UILabel *lDriftDownMinElevation;
@property (strong, nonatomic) IBOutlet UILabel *lResultCheck;
@property (strong, nonatomic) IBOutlet UILabel *lMEA1plusGeschUeberhoehung;


@property (strong, nonatomic) IBOutlet UITextField *inputMEA2elevation;
@property (strong, nonatomic) IBOutlet UITextField *inputMEA2distance;
@property (strong, nonatomic) IBOutlet UILabel *lMEA2diffToSC;
@property (strong, nonatomic) IBOutlet UILabel *lSliderGeschUeberhoehungMEA2;
@property (strong, nonatomic) IBOutlet UISlider *sliderGeschUeberMEA2;
- (IBAction)sliderActionGeschUeberMEA2:(id)sender;
@property (strong, nonatomic) IBOutlet UILabel *lUeberhoehungTotalMEA2;
@property (strong, nonatomic) IBOutlet UILabel *lhoehenverlusstMEA2;
@property (strong, nonatomic) IBOutlet UILabel *lhoehenverlusstTotalMEA2;
@property (strong, nonatomic) IBOutlet UILabel *lUeberhoehungFuerGanzesLegMEA2;
@property (strong, nonatomic) IBOutlet UILabel *lDriftDownMinElevationMEA2;
@property (strong, nonatomic) IBOutlet UILabel *lResultCheckMEA2;
@property (strong, nonatomic) IBOutlet UILabel *lMEA2plusGeschUeberhoehung;

- (IBAction)closeKeyboardDriftDown:(id)sender;

@end
